require File.join(File.dirname(__FILE__), 'lib/license_helpers')

module Licenses
  class Main < Sinatra::Base
    set :root, File.dirname(__FILE__)

    helpers LicenseHelpers

    configure do

      dir = Console::Config['dashboard_root']

      settings = YAML::load(IO.read(File.join(dir, 'config', 'settings.yml')))
      local_settings = YAML::load(IO.read(File.join(File.dirname(__FILE__), 'config.yml')))

      set :ca_file_path, local_settings['ssl']['cacert']
      set :cert_key_path, local_settings['ssl']['key']
      set :cert_path, local_settings['ssl']['cert']
      set :puppetdb_host, local_settings['puppetdb']['host']
      set :puppetdb_port, local_settings['puppetdb']['port']

      enable :logging

      mime_type :license,
        "application/vnd.puppetlabs.license-data.v1+json"
      mime_type :license_count,
        "application/vnd.puppetlabs.license.metadata.v1+json"
      mime_type :node_count,
        "application/vnd.puppetlabs.node.metadata.v1+json"
    end

    before do
      cache_control :no_cache
    end

    get '/api/v1/license' do
      #content_type :license
      content_type :json
      get_license.to_json
    end

    get '/api/v1/license_count' do
      #content_type :license_count
      content_type :json
      {:license_count => get_license_count}.to_json
    end

    get '/api/v1/node_count' do
      #content_type :node_count
      content_type :json
      {:node_count => get_node_count}.to_json
    end

    get '/api/v1/license_status' do
      content_type :json
      license = get_license
      node_count = get_node_count
      license_count = get_license_count
      expired_flag = license.expired?
      { :license_count   => license_count,
        :node_count      => node_count,
        :expired         => expired_flag,
        :title           => title_text(node_count, license),
        :contact_us_text => contact_us_text(node_count, license),
        :footer          => license_footer(license),
      }.to_json
    end

  end
end
