require 'spec_helper'

describe 'pe_repo' do
  let(:facts) do
    {
      :pe_build => '2015.10.99'
    }
  end

  let(:params) do
    {
      #:base_path => "https://pm.puppetlabs.com/puppet-enterprise",
      #:repo_dir => "/opt/puppetlabs/server/data/packages",
      #:prefix => "/packages",
      #:master => $settings::server,
    }
  end

  # Add these two lines in a single test block to enable puppet and hiera debug mode
  # Puppet::Util::Log.level = :debug
  # Puppet::Util::Log.newdestination(:console)
  context 'default parameters' do
    it do
      is_expected.to contain_file('/opt/puppetlabs/server/data/packages').
               with({"ensure"=>"directory"})
    end
    it do
      is_expected.to contain_file('/opt/puppetlabs/server/data/packages/public').
               with(
                {"ensure"=>"directory",
                "mode"=>'0755'},
                )
    end
    it do
      is_expected.to contain_file('/opt/puppetlabs/server/data/packages/public/current').
               with({"ensure"=>"link",
                     "target"=>"/opt/puppetlabs/server/data/packages/public/2015.10.99"})
    end
    it do
      is_expected.to contain_file('/opt/puppetlabs/server/data/packages/public/GPG-KEY-puppetlabs').
               with({"source"=>"puppet:///modules/pe_repo/GPG-KEY-puppetlabs"})
    end
  end
end
