#pragma once

#include <string>
#include "export.h"

namespace puppet_access { namespace config {

const std::string default_certificate_file = "/etc/puppetlabs/puppet/ssl/certs/ca.pem";

struct config {
    const std::string token_file;
    const std::string certificate_file;
    const std::string service_url;

    config(const std::string& token_file,
           const std::string& certificate_file)
        : token_file(token_file), certificate_file(certificate_file) {}

    config(const std::string& token_file,
           const std::string& certificate_file,
           const std::string& service_url)
        : token_file(token_file), certificate_file(certificate_file), service_url(service_url) {}

    std::string LIBPUPPET_ACCESS_EXPORT pretty_print() const;
};

extern const config LIBPUPPET_ACCESS_EXPORT default_config;

std::string LIBPUPPET_ACCESS_EXPORT get_default_token_file();
std::string LIBPUPPET_ACCESS_EXPORT get_default_config_file();
config LIBPUPPET_ACCESS_EXPORT merge(const config& cfg1, const config& cfg2);
config LIBPUPPET_ACCESS_EXPORT parse_config(const std::string& json_body);
config LIBPUPPET_ACCESS_EXPORT config_from_file(const std::string& path);

}  // namespace request
}  // namespace puppet_access
