/**
 * @file
 * Declares a utility for retrieving the library version.
 */
#pragma once

#include <string>
#include <vector>
#include <boost/filesystem.hpp>
#include <boost/filesystem/fstream.hpp>
#include "export.h"

#include <leatherman/json_container/json_container.hpp>

namespace puppet_access {

const std::string token_header = "X-Authentication";

using leatherman::json_container::JsonContainer;

/**
 * Query the library version.
 * @return A version string with <major>.<minor>.<patch>
 */
std::string LIBPUPPET_ACCESS_EXPORT version();
void LIBPUPPET_ACCESS_EXPORT save_token(const std::string& token,
                                        const boost::filesystem::path& token_path);

std::string LIBPUPPET_ACCESS_EXPORT request_token(const std::string& url,
                                                  const std::string& ca_cert,
                                                  const std::string& user,
                                                  const std::string& password);

std::string LIBPUPPET_ACCESS_EXPORT request_token(const std::string& url,
                                                  const std::string& ca_cert,
                                                  const std::string& user,
                                                  const std::string& password,
                                                  const std::string& lifetime);

std::string LIBPUPPET_ACCESS_EXPORT read_token(const boost::filesystem::path& token_path);

void LIBPUPPET_ACCESS_EXPORT delete_token(const boost::filesystem::path& token_path);

std::vector<JsonContainer> LIBPUPPET_ACCESS_EXPORT parse_token(const std::string& token);

void validate_file_readable(const std::string& file_path);

void make_directories(const boost::filesystem::path& path);

void secure_permissions(const boost::filesystem::path& path);

boost::filesystem::path setup_parent_directory(const boost::filesystem::path& path);

}  // namespace puppet_access
