module Puppet::Parser::Functions
  newfunction(:pe_compile_master, :type => :rvalue, :doc => <<-EOS
    Returns whether or not the current master is a compile master
  EOS
  ) do |args|


    if args.length > 0 then
      raise Puppet::ParseError, ("pe_compile_master(): wrong number of arguments (#{args.length}; must be 0)")
    end

    servername = lookupvar('servername')
    fqdn = lookupvar('fqdn')
    servername and servername != fqdn
  end
end