class puppet_enterprise::master::file_sync_disabled()
  inherits puppet_enterprise::params {

  $container = 'puppetserver'
  $confdir = "/etc/puppetlabs/${container}"

  Puppet_enterprise::Trapperkeeper::Bootstrap_cfg {
    container => $container,
  }

  puppet_enterprise::trapperkeeper::bootstrap_cfg { 'file-sync-versioned-code-disabled-service' :
    namespace => 'puppetlabs.enterprise.services.file-sync.file-sync-versioned-code-disabled-service'
  }

  #PE File Sync configuration
  file { "${confdir}/conf.d/file-sync.conf" :
    ensure => absent,
    notify => Service["pe-${container}"],
  }

  Pe_puppet_authorization::Rule {
    path   => "${confdir}/conf.d/auth.conf",
    notify => Service["pe-${container}"],
  }

  pe_puppet_authorization::rule { 'puppetlabs file sync api':
    ensure => absent,
  }

  pe_puppet_authorization::rule { 'puppetlabs file sync repo':
    ensure => absent,
  }
}
