# This class sets up the agent. For more information, see the [README.md](./README.md)
#
# @param manage_symlinks [Boolean] Flag to enable creation of convenience links
class puppet_enterprise::profile::agent(
  Boolean $manage_symlinks = $puppet_enterprise::manage_symlinks,
  Boolean $pxp_enabled     = true,
  String $pcp_broker_host  = $puppet_enterprise::pcp_broker_host,
  Integer $pcp_broker_port = $puppet_enterprise::pcp_broker_port,
) inherits puppet_enterprise {

  include puppet_enterprise::symlinks

  if $manage_symlinks {
    File <| tag == 'pe-agent-symlinks' |>
  }

  if $pxp_enabled and $puppet_enterprise::params::pxp_compatible {
    class { 'puppet_enterprise::pxp_agent':
      broker_ws_uri => "wss://${pcp_broker_host}:${pcp_broker_port}/pcp/"
    }
  }
}
