define puppet_enterprise::trapperkeeper::orchestrator(
  $master_url,
  $puppetdb_url,
  $classifier_url,
  $rbac_url,
  $pcp_broker_url,
  $use_application_services,
  $client_certname     = $puppet_enterprise::params::orchestrator_client_certname,
  $container           = $title,
  $database_host       = 'localhost',
  $database_port       = $puppet_enterprise::params::database_port,
  $database_name       = "pe-orchestrator",
  $database_user       = "pe-orchestrator",
  $database_password   = '',
  $database_properties = '',
  $user                = "pe-${title}",
  $group               = "pe-${title}",
  Integer $pcp_timeout = 5,
) {

  $confdir = "/etc/puppetlabs/${container}/conf.d"
  file { "${confdir}/orchestrator.conf":
    ensure => present,
    owner  => $user,
    group  => $group,
    mode   => '0640',
  }

  pe_hocon_setting { "${container}.orchestrator.master-url":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.master-url',
    value   => $master_url,
  }

  pe_hocon_setting { "${container}.orchestrator.puppetdb-url":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.puppetdb-url',
    value   => $puppetdb_url,
  }

  pe_hocon_setting { "${container}.orchestrator.classifier-service":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.classifier-service',
    value   => $classifier_url,
  }

  pe_hocon_setting { "${container}.orchestrator.rbac-service":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.rbac-service',
    value   => $rbac_url,
  }

  pe_hocon_setting { "${container}.orchestrator.pcp-broker-url":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.pcp-broker-url',
    value   => $pcp_broker_url,
  }

  pe_hocon_setting { "${container}.orchestrator.ssl-ca-cert":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.ssl-ca-cert',
    value   => $puppet_enterprise::params::localcacert,
  }

  pe_hocon_setting { "${container}.orchestrator.ssl-cert":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.ssl-cert',
    value   => "/etc/puppetlabs/${container}/ssl/${client_certname}.cert.pem",
  }

  pe_hocon_setting { "${container}.orchestrator.ssl-key":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.ssl-key',
    value   => "/etc/puppetlabs/${container}/ssl/${client_certname}.private_key.pem",
  }

  pe_hocon_setting { "${container}.orchestrator.pcp-timeout":
    ensure  => present,
    path    => "${confdir}/orchestrator.conf",
    setting => 'orchestrator.pcp-timeout',
    value   => $pcp_timeout,
  }

  unless pe_empty($database_password) {
    pe_hocon_setting { "${container}.orchestrator.database.subname":
      ensure  => present,
      path    => "${confdir}/orchestrator.conf",
      setting => 'orchestrator.database.subname',
      value   => "//${database_host}:${database_port}/${database_name}${database_properties}",
    }

    pe_hocon_setting { "${container}.orchestrator.database.user":
      ensure  => present,
      path    => "${confdir}/orchestrator.conf",
      setting => 'orchestrator.database.user',
      value   => $database_user,
    }

    pe_hocon_setting { "${container}.orchestrator.database.password":
      ensure  => present,
      path    => "${confdir}/orchestrator.conf",
      setting => 'orchestrator.database.password',
      value   => $database_password,
    }
  }

  if $use_application_services {
    puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}:orchestrator orchestrator-service" :
      container => $container,
      namespace => 'puppetlabs.orchestrator.service',
      service   => 'orchestrator-service',
    }

    puppet_enterprise::trapperkeeper::bootstrap_cfg { "${container}:orchestrator jetty9-service" :
      container => $container,
      namespace => 'puppetlabs.trapperkeeper.services.webserver.jetty9-service',
      service   => 'jetty9-service',
    }
  }
}
