require 'spec_helper'

describe 'puppet_enterprise::master::code_manager' do
  before :all do
    @facter_facts = {
      'osfamily'          => 'Debian',
      'operatingsystem'   => 'Debian',
      'lsbmajdistrelease' => '6',
      'puppetversion'     => '3.6.2 (Puppet Enterprise 3.3.0)',
      'is_pe'             => 'true',
      'fqdn'              => 'master.rspec',
      'clientcert'        => 'awesomecert',
      'pe_concat_basedir' => '/tmp/file',
      'processorcount'    => '1',
      'servername'        => 'master.rspec'
    }

    @params = {
      'certname'         => 'master.rspec',
    }
  end

  let(:facts)   { @facter_facts }
  let(:params)  { @params }
  let(:confdir) { "/etc/puppetlabs/puppetserver" }

  context 'no control repo configuration provided' do
    it { should contain_pe_hocon_setting('code-manager.sources').with_ensure('absent') }
  end

  context 'without forge_settings' do
    it { should contain_pe_hocon_setting('code-manager.forge').with_ensure('absent') }
    it { should contain_pe_hocon_setting('code-manager.forge-settings').with_ensure('absent') }
  end

  context 'with forge_settings' do
    before(:each) { @params['forge_settings'] = {'proxy' => 'https://forge.proxy'} }
    it { should contain_pe_hocon_setting('code-manager.forge').with_ensure('present') }
    it { should contain_pe_hocon_setting('code-manager.forge').with_value({'proxy' => 'https://forge.proxy'}) }
    it { should contain_pe_hocon_setting('code-manager.forge-settings').with_ensure('absent') }
  end

  context 'with a remote repo information provided' do
    before :each do
      @params['remote'] = 'git@github.com:puppetlabs/pupeptlabs-modules'
    end

    it do
      sources = { 'puppet' => { 'remote' => 'git@github.com:puppetlabs/pupeptlabs-modules'}}
      should contain_pe_hocon_setting('code-manager.sources').with_value(sources)
    end
  end

  context 'with sources provided' do
    before :each do
      @params['remote'] = 'git@github.com:puppetlabs/pupeptlabs-modules'
      @params['sources'] = {'puppet' => {} }
    end

    it do
      should contain_pe_hocon_setting('code-manager.sources').with_value(@params['sources'])
    end
  end

  context 'with file_sync_auto_commit' do
    it { should contain_pe_hocon_setting('code-manager.environmentdir').with_value('/etc/puppetlabs/code-staging/environments') }
    it { should contain_puppet_enterprise__trapperkeeper__bootstrap_cfg('code-manager-v1') }
  end

  context 'with file_sync_auto_commit' do
    before :each do
      @params['file_sync_auto_commit'] = false
    end

    it { should contain_pe_hocon_setting('code-manager.environmentdir').with_value('/etc/puppetlabs/code/environments') }
    it { should contain_puppet_enterprise__trapperkeeper__bootstrap_cfg('code-manager-v1-no-file-sync') }
  end

  context 'with a private key provided' do
    before :each do
      @params['private_key'] = '/etc/puppetlabs/code-manager/id_rsa'
    end

    it do
      should contain_pe_hocon_setting('code-manager.private-key').with_value(@params['private_key'])
    end
  end
end
