require 'spec_helper'

describe 'puppet_enterprise::master::file_sync_disabled' do
  let(:confdir) { "/etc/puppetlabs/puppetserver" }

  context "remove the file-sync.conf file" do
    it { should contain_file("#{confdir}/conf.d/file-sync.conf").with_ensure('absent')}
  end

  context "add the disabled sync service to the bootstrap.cfg" do
    it { should contain_pe_concat__fragment('puppetserver file-sync-versioned-code-disabled-service') }
  end

  context "remove the authorization rules" do
    it { should contain_pe_puppet_authorization__rule('puppetlabs file sync api')
      .with_path('/etc/puppetlabs/puppetserver/conf.d/auth.conf')
      .with_notify('Service[pe-puppetserver]') }
    it { should contain_pe_puppet_authorization__rule('puppetlabs file sync repo')
      .with_path('/etc/puppetlabs/puppetserver/conf.d/auth.conf')
      .with_notify('Service[pe-puppetserver]') }
  end
end
