require 'spec_helper'

describe 'puppet_enterprise::profile::orchestrator' do
  before :each do
    @facter_facts = {
      'kernel'            => 'Linux',
      'osfamily'          => 'Debian',
      'operatingsystem'   => 'Debian',
      'lsbmajdistrelease' => '6',
      'puppetversion'     => '3.6.2 (Puppet Enterprise 3.3.0)',
      'serverversion'     => '3.6.2 (Puppet Enterprise 3.3.0)',
      'is_pe'             => 'true',
      'fqdn'              => 'master.rspec',
      'clientcert'        => 'awesomecert',
      'pe_concat_basedir'    => '/tmp/file',
      'processorcount'    => '1',
    }

    @params = {
      'certname' => 'orchestrator.rspec',
      'database_host' => 'db.rspec',
      'master_host' => 'master.rspec',
      'puppetdb_host' => 'puppetdb.rspec',
      'classifier_host' => 'classifier.rspec',
      'rbac_host' => 'rbac.rspec',
    }
  end

  let(:facts) { @facter_facts }
  let(:params) { @params }

  context "when managing default java_args" do
    it { should contain_pe_ini_subsetting("pe-orchestration-services_'Xmx'").with_value( '192m' ) }
    it { should contain_pe_ini_subsetting("pe-orchestration-services_'Xms'").with_value( '192m' ) }
  end

  context "with custom java_args" do
    before(:each) { @params['java_args'] = { 'Xmx' => '128m' } }
    it { should contain_pe_ini_subsetting("pe-orchestration-services_'Xmx'").with(
     'value'   => '128m',
     'require' => 'Package[pe-orchestration-services]',
    ) }
  end

  context "with valid parameters" do
    context "configuring the webserver" do
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.websocket.route").with_value('/pcp') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.websocket.server").with_value('pcp-broker') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.metrics.route").with_value('/') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.metrics.server").with_value('pcp-broker') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.client-auth").with_value('want') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.ssl-host").with_value('0.0.0.0') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.ssl-port").with_value(8142) }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.ssl-ca-cert").with_value('/etc/puppetlabs/puppet/ssl/certs/ca.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.ssl-cert").with_value('/etc/puppetlabs/orchestration-services/ssl/orchestrator.rspec.cert.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.pcp-broker.ssl-key").with_value('/etc/puppetlabs/orchestration-services/ssl/orchestrator.rspec.private_key.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.websocket.route").with(:setting => 'web-router-service."puppetlabs.pcp.broker.service/broker-service".websocket.route',
                                                                                                                            :value   => '/pcp') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.websocket.server").with(:setting => 'web-router-service."puppetlabs.pcp.broker.service/broker-service".websocket.server',
                                                                                                                             :value   => 'pcp-broker') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.metrics.route").with(:setting => 'web-router-service."puppetlabs.pcp.broker.service/broker-service".metrics.route',
                                                                                                                            :value   => '/') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.broker-service.metrics.server").with(:setting => 'web-router-service."puppetlabs.pcp.broker.service/broker-service".metrics.server',
                                                                                                                             :value   => 'pcp-broker') }
    end

    it { should contain_puppet_enterprise__certs('pe-internal-orchestrator').with(:certname => 'pe-internal-orchestrator') }
    it { should contain_puppet_enterprise__certs('pe-orchestration-services').with(:certname => 'orchestrator.rspec') }

    it { should contain_pe_concat__fragment('orchestration-services webrouting-service') }


    context "with application_services enabled" do
      before :each do
        @params['use_application_services'] = true
      end

      it { should contain_service('pe-orchestration-services').with(:ensure => true, :enable => true) }

      it { should contain_puppet_enterprise__trapperkeeper__orchestrator('orchestration-services').with(:database_host => 'db.rspec',
                                                                                                      :database_user => 'pe-orchestrator',
                                                                                                      :database_password => '',
                                                                                                      :classifier_url => 'https://classifier.rspec:4433/classifier-api',
                                                                                                      :rbac_url => 'https://rbac.rspec:4433/rbac-api',
                                                                                                      :pcp_broker_url => 'wss://orchestrator.rspec:8142/pcp') }
      it { should contain_puppet_enterprise__trapperkeeper__pcp_broker('orchestration-services').with(:accept_consumers => '2',
                                                                                                    :delivery_consumers => '2') }

      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.client-auth").with_value('none') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.default-server").with_value(true) }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.ssl-host").with_value('0.0.0.0') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.ssl-port").with_value(8143) }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.ssl-ca-cert").with_value('/etc/puppetlabs/puppet/ssl/certs/ca.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.ssl-cert").with_value('/etc/puppetlabs/orchestration-services/ssl/orchestrator.rspec.cert.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.webserver.orchestrator.ssl-key").with_value('/etc/puppetlabs/orchestration-services/ssl/orchestrator.rspec.private_key.pem') }
      it { should contain_pe_hocon_setting("orchestration-services.web-router-service.orchestrator-service").with_value('/orchestrator/v1') }
    end
  end
end
