require 'spec_helper'

describe 'puppet_enterprise::trapperkeeper::orchestrator' do
  before :each do
    @facter_facts = {
      'kernel'            => 'Linux',
      'osfamily'          => 'Debian',
      'operatingsystem'   => 'Debian',
      'lsbmajdistrelease' => '6',
      'puppetversion'     => '3.6.2 (Puppet Enterprise 3.3.0)',
      'serverversion'     => '3.6.2 (Puppet Enterprise 3.3.0)',
      'is_pe'             => 'true',
      'fqdn'              => 'master.rspec',
      'clientcert'        => 'awesomecert',
      'pe_concat_basedir'    => '/tmp/file',
      'processorcount'    => '1',
    }

    @params = {
      'database_host' => 'db.rspec',
      'master_url' => 'https://master.rspec:8140',
      'puppetdb_url' => 'https://puppetdb.rspec:8081',
      'classifier_url' => 'https://classifier.rspec:4433/classifier-api',
      'rbac_url' => 'https://rbac.rspec:4433/rbac-api',
      'pcp_broker_url' => 'wss://pcp.rspec:8142/pcp',
      'use_application_services' => 'false',
    }

  end

  let(:facts) { @facter_facts }
  let(:params) { @params }
  let(:title) { 'orchestration-services' }
  let(:confdir) { "/etc/puppetlabs/#{title}" }

  it { should contain_file("#{confdir}/conf.d/orchestrator.conf").with(:owner => 'pe-orchestration-services',
                                                                       :group => 'pe-orchestration-services',
                                                                       :mode  => '0640') }

  context "configuring the SSL client" do
    it { should contain_pe_hocon_setting("#{title}.orchestrator.ssl-cert").with_value("#{confdir}/ssl/pe-internal-orchestrator.cert.pem") }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.ssl-key").with_value("#{confdir}/ssl/pe-internal-orchestrator.private_key.pem") }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.ssl-ca-cert").with_value("/etc/puppetlabs/puppet/ssl/certs/ca.pem") }
  end

  context "managing integration with other services" do
    it { should contain_pe_hocon_setting("#{title}.orchestrator.master-url").with_value('https://master.rspec:8140') }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.puppetdb-url").with_value('https://puppetdb.rspec:8081') }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.classifier-service").with_value('https://classifier.rspec:4433/classifier-api') }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.rbac-service").with_value('https://rbac.rspec:4433/rbac-api') }
    it { should contain_pe_hocon_setting("#{title}.orchestrator.pcp-broker-url").with_value('wss://pcp.rspec:8142/pcp') }
  end

  context "configuring database settings" do
    context "with db password specified" do
      before :each do
        @params['database_password'] = 'thesupersecretpassword'
      end
      it { should contain_pe_hocon_setting("#{title}.orchestrator.database.subname").with_value('//db.rspec:5432/pe-orchestrator') }
      it { should contain_pe_hocon_setting("#{title}.orchestrator.database.user").with_value('pe-orchestrator') }
      it { should contain_pe_hocon_setting("#{title}.orchestrator.database.password").with_value('thesupersecretpassword') }
    end

    context "with db password not specified" do
      it { should_not contain_pe_hocon_setting("#{title}.orchestrator.database.subname") }
      it { should_not contain_pe_hocon_setting("#{title}.orchestrator.database.user") }
      it { should_not contain_pe_hocon_setting("#{title}.orchestrator.database.password") }
    end
  end

  context "configuring bootstrap.cfg" do
    before :each do
      @params['use_application_services'] = 'true'
    end
    it { should contain_pe_concat__fragment('orchestration-services orchestrator-service') }
    it { should contain_pe_concat__fragment('orchestration-services jetty9-service') }
  end
end
