#! /usr/bin/env ruby -S rspec
require 'spec_helper'

describe 'the pe_sort function' do
  let(:scope) { PuppetlabsSpec::PuppetInternals.scope }

  it "should exist" do
    expect(Puppet::Parser::Functions.function("pe_sort")).to eq("function_pe_sort")
  end

  it "should raise a ParseError if there is less than 1 argument" do
    expect { scope.function_pe_sort([]) }.to( raise_error(Puppet::ParseError))
  end

  it "should sort elements in a string" do
    result = scope.function_pe_sort(["cbda"])
    expect(result).to(eq('abcd'))
  end

  it "should sort elements in an array" do
    result = scope.function_pe_sort([["c", "b", "a"]])
    expect(result).to(eq(['a','b','c']))
  end
end
