require 'spec_helper_acceptance'

describe 'pe_postgresql::server::database_grant:', :unless => UNSUPPORTED_PLATFORMS.include?(fact('osfamily')) do
  after :all do
    # Cleanup after tests have ran
    apply_manifest("class { 'pe_postgresql::server': ensure => absent }", :catch_failures => true)
  end

  it 'should grant access so a user can create objects in a database' do
    begin
      pp = <<-EOS.unindent
        $db = 'postgres'
        $user = 'psql_grant_tester'
        $password = 'psql_grant_pw'

        class { 'pe_postgresql::server': }

        # Since we are not testing pg_hba or any of that, make a local user for ident auth
        user { $user:
          ensure => present,
        }

        pe_postgresql::server::role { $user:
          password_hash => pe_postgresql_password($user, $password),
        }

        pe_postgresql::server::database { $db: }

        pe_postgresql::server::database_grant { 'grant create test':
          privilege => 'CREATE',
          db        => $db,
          role      => $user,
        }
      EOS

      apply_manifest(pp, :catch_failures => true)
      apply_manifest(pp, :catch_changes => true)

      # Check that the user can create a table in the database
      psql('--command="create table foo (foo int)" postgres', 'psql_grant_tester') do |r|
        expect(r.stdout).to match(/CREATE TABLE/)
        expect(r.stderr).to eq('')
      end
    ensure
      psql('--command="drop table foo" postgres', 'psql_grant_tester')
    end
  end
end
