require 'cgi'
require 'json'

require 'pe_license'

class PELicense::Status
  def self.metric
    CGI.escape('puppetlabs.puppetdb.query.population:type=default,name=num-nodes')
  end

  def self.retrieve(conn)
    begin
      response = conn.get("/metrics/v1/mbeans/#{metric}")
      code = response.code.to_i
      raise response.body unless (200...300).include?(response.code.to_i)

      result = JSON.parse(response.body)

      nodes = result['Value']

      new(nodes)
    rescue => e
      raise "Unable to retrieve number of licensed nodes from PuppetDB: #{e}"
    end
  end

  attr_reader :nodes

  def initialize(nodes)
    @nodes = nodes
  end
end
