require 'spec_helper'

describe 'pe_razor::server::config' do
  before :each do
    @facter_facts = {
      'operatingsystem'           => 'RedHat',
      'operatingsystemmajrelease' => '6',
      'pe_razor_server_version'   => '1.0.1.1',
    }
    @params = {
      'dbpassword' => 'strongPassword1234',
      'server_http_port'          => '8150',
      'server_https_port'         => '8151',
    }
  end

  let(:params) { @params }
  let(:facts) { @facter_facts }

  context 'with valid parameters' do
    it { should contain_file('/etc/sysconfig/pe-razor-server').with(
      :ensure => 'file',
      :owner => 'root',
      :mode => '0644',
    ).with_content(<<EOF) }
# Managed by pe_razor
# The location of the razor config files
RAZOR_CONFIG=/etc/puppetlabs/razor-server/config.yaml
RAZOR_CONFIG_DEFAULTS=/opt/puppetlabs/server/apps/razor-server/config-defaults.yaml
# The ports that the razor-server service should listen on
RAZOR_HTTP_PORT=8150
RAZOR_HTTPS_PORT=8151
# Kept for backwards-compatibility during upgrade from 1.0.1.0
HTTP_PORT=8150
HTTPS_PORT=8151
EOF
    it { should contain_file('/opt/puppetlabs/server/data/razor-server').with(
      :ensure => 'directory',
      :owner  => 'root'
    ) }
    it { should contain_file('/etc/puppetlabs/razor-server').with(
      :ensure => 'directory',
      :owner  => 'pe-razor',
      :mode   => '0640',
    ) }
    it { should contain_file('/opt/puppetlabs/server/data/razor-server/repo').with(
      :ensure => 'directory',
      :owner  => 'pe-razor',
      :mode   => '0755',
    ) }
    it { should contain_file('/etc/puppetlabs/razor-server/config.yaml').with_content(/database_url.*password=strongPassword1234'/) }
    it { should contain_file('/opt/puppetlabs/server/apps/razor-server/config-defaults.yaml').with_content(/database_url.*password=strongPassword1234'/) }
    it { should contain_file('/etc/puppetlabs/razor-server/shiro.ini') }
  end
end
