require 'installer/errors'

# Creates a temp directory on the hosts provided. Will block until completion.
class Installer::Action::Mktemp < Installer::Action
  attr_reader :results, :hosts

  # TODO: Document args
  def initialize(host, template, args = {})
    super(args)

    @host = host
    @template = template
    @chmod = args[:chmod] || '700'
    @sudo = args[:sudo] || false
  end


  # TODO: Document block format
  def go(&stream_block)
    @status = :running
    @results = { @host.hostname => {} }
    mktemp = exec_and_log(@host, "mktemp -d -t '#{@template}'", @sudo, @results[@host.hostname], &stream_block)

    if mktemp[:exit_status] == 0
      @dir = mktemp[:stdout].strip
      exec_and_log(@host, "chmod #{@chmod} #{@dir}", @sudo, @results[@host.hostname], &stream_block)
    end

    @results
  end

  def success?
    @results.all? do |host, result|
      result[:exit_status] == 0
    end
  end

  def dir
    @dir
  end

  def error_message(hostname)
    if @results.has_key?(hostname) && @results[hostname].has_key?(:stderr)
      @results[hostname][:stderr].strip
    end
  end

  def name
    :mktemp
  end

  def description
    "Make temporary directory on #{@hosts.join(', ')}"
  end
end
