class Installer::Planner
  class Step
    attr_reader :infra, :actions, :hosts, :messages, :status

    def initialize(infra, data={}, pre=nil, post=nil)
      @pre = pre
      @post = post
      @infra = infra
      @data = data
      @hosts = Set.new
      @hosts.merge(@infra.hosts.values)

      @actions = []
      @messages = []

      @status = :success
      @uuid = SecureRandom.uuid

      raise 'No translations available, has r18n been loaded?' unless data[:r18n]
      @t = data[:r18n]
    end

    def perform_step(&execute)
      raise NotImplementedError, "Don't know how to perform this kind of step"
    end

    def name
      raise NotImplementedError, "Step name required"
    end

    def description
      raise NotImplementedError, "Step description required"
    end

    def fail_stop?
      false
    end

    def reset
      @status = :success
      @messages.clear
    end

    def error(hostname, message)
      @messages << Installer::Event::Message.new(:error, hostname, message)
      @status = :error
    end

    def warning(hostname, message)
      @messages << Installer::Event::Message.new(:warn, hostname, message)
      @status = :warn unless @status == :error
    end

    def info(hostname, message)
      @messages << Installer::Event::Message.new(:info, hostname, message)
    end
  end
end

require 'installer/event'
require 'installer/planner/step/backup_logs'
require 'installer/planner/step/check_dns'
require 'installer/planner/step/check_cross_dns'
require 'installer/planner/step/check_local_environment'
require 'installer/planner/step/connect_ssh'
require 'installer/planner/step/check_root'
require 'installer/planner/step/compatibility_check'
require 'installer/planner/step/hardware_check'
require 'installer/planner/step/filesystem_check'
require 'installer/planner/step/install_pe'
require 'installer/planner/step/noop'
require 'installer/planner/step/purge_pe'
require 'installer/planner/step/destroy_pe'
require 'installer/planner/step/verify_puppet'
require 'installer/planner/step/verify_mco'
