require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::CheckCrossDNS < Installer::Planner::Step
  def initialize(infra, data={}, pre=nil, post=nil)
    super

    master = @infra.master
    puppetdb = @infra.puppetdb
    console = @infra.console

    # Ensure that all hosts can resolve DNS for the master.
    @infra.hosts.each do |hostname, host|
      @actions << Installer::Action::ResolveDNS.new(:from => host, :address => master.hostname)
    end

    # For a split install, ensure that each role can connect to the other roles it needs to.
    if @infra.hosts.length > 1
      @actions << Installer::Action::ResolveDNS.new(:from => master, :address => puppetdb.hostname)
      @actions << Installer::Action::ResolveDNS.new(:from => master, :address => console.hostname)
      @actions << Installer::Action::ResolveDNS.new(:from => console, :address => puppetdb.hostname)
    end
  end

  def perform_step(&stream_block)
    @actions.each do |action|
      yield action

      if ! action.success?
        error(action.from, @t.step.cross_check_dns.dns_resolution_failed(from: action.from, address: action.address))
      end
    end
  end

  def name
    :check_cross_dns
  end

  def description
    @t.step.cross_check_dns.description(hosts: @infra.hosts.keys.join(', '))
  end
end
