require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::CheckDNS < Installer::Planner::Step
  def perform_step(&stream_block)
    @infra.hosts.each do |hostname, host|
      resolve = Installer::Action::ResolveDNS.new(:address => hostname)
      yield resolve

      if ! resolve.success?
        error(hostname, @t.step.check_dns.resolve_failed(hostname: hostname))
      end
    end
  end

  def fail_stop?
    true
  end

  def name
    :check_dns
  end

  def description
    @t.step.check_dns.description(hostname: @infra.installer_hostname, hosts: @infra.hosts.keys.join(', '))
  end
end
