require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::CheckLocalEnvironment < Installer::Planner::Step
  def initialize(infra, data={}, pre=nil, post=nil)
    raise 'No install dir provided' unless data[:installer_dir]
    @installer_dir = data[:installer_dir]

    raise 'No work dir provided' unless data[:work_dir]
    @work_dir = data[:work_dir]
    super
  end

  def perform_step(&stream_block)
    unless File.directory? @work_dir
      error('localhost', @t.step.check_local_environment.no_work_dir(dir: @work_dir))
    end

    unless File.directory? @installer_dir
      error('localhost', @t.step.check_local_environment.no_pe(dir: @installer_dir))
    end
  end

  def fail_stop?
    true
  end

  def name
    :check_local_environment
  end

  def description
    @t.step.check_local_environment.description
  end
end
