require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::CheckRoot < Installer::Planner::Step
  def perform_step(&stream_block)
    @infra.hosts.each do |hostname, host|
      # If we're connecting as root, then no problem!
      if host.username != 'root'
        echo = Installer::Action::Execute.new(:host => host, :cmd => '/bin/echo testing root access', :sudo => true)
        begin
          yield echo
          error(hostname, @t.step.check_root.failed(hostname: hostname)) unless echo.success?
        rescue Installer::RemoteError => e
          # sudo problems could result in a remote error, which we want to recognize
          error(hostname, @t.step.check_root.failed_error(hostname: hostname, error: e.message))
        end
      end
    end
  end

  def fail_stop?
    true
  end

  def name
    :check_root
  end

  def description
    @t.step.check_root.description(hosts: @infra.hosts.keys.join(', '))
  end
end
