require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::DestroyPE < Installer::Planner::Step
  def initialize(infra, data={}, pre=nil, post=nil)
    super

    @host = @infra.hosts[data[:host]] if data[:host]
  end

  def perform_step(&execute)
    remove_temp = Installer::Action::Execute.new(:host => @host, :sudo => true, :cmd => "rm -rf /tmp/pe-installer*")
    yield remove_temp

    remove_pe = Installer::Action::Execute.new(:host => @host, :sudo => true, :cmd => "rm -rf /opt/puppet")
    yield remove_pe

    remove_etc = Installer::Action::Execute.new(:host => @host, :sudo => true, :cmd => "rm -rf /etc/puppetlabs")
    yield remove_etc
  end

  def name
    :uninstall_pe
  end

  def description
    "Destroy PE from orbit; it's the only way to be sure."
  end
end
