require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::PurgePE < Installer::Planner::Step
  def initialize(infra, data={}, pre=nil, post=nil)
    super

    @host = @infra.hosts[data[:host]] if data[:host]
    @local_installer_dir = data[:local_installer_dir]
  end

  def perform_step(&execute)
    mktemp = Installer::Action::Mktemp.new(@host, "pe-installer-XXXXXXXX")
    yield mktemp
    unless mktemp.success?
      error(@host.hostname, "Failed to create temporary directory for PE installation: #{mktmp.results}")
      return
    end

    # TODO: Some parsing for the tmp dir? Define these better
    tmpdir = Pathname.new(mktemp.dir)

    # Ensure there is an installer available to copy
    unless File.readable? "#{@local_installer_dir}/puppet-enterprise-uninstaller"
      error("localhost", "PE Un-Installer not found in directory #{@local_installer_dir}")
      return
    end

    # Copy uninstaller files
    uninstaller = Installer::Action::Upload.new(:to_host => @host, :from => "#{@local_installer_dir}/puppet-enterprise-uninstaller", :to => "#{tmpdir}/puppet-enterprise-uninstaller")
    yield uninstaller
    utils = Installer::Action::Upload.new(:to_host => @host, :from => "#{@local_installer_dir}/utilities", :to => "#{tmpdir}/utilities")
    yield utils
    unless uninstaller.success? && utils.success?
      error(@host.hostname, "Failed to copy uninstaller to host #{@host.hostname} for PE installation")
      return
    end

    uninstall = Installer::Action::Execute.new(:host => @host, :sudo => true, :cmd => "#{tmpdir}/puppet-enterprise-uninstaller -ydp")
    yield uninstall
    unless uninstall.success?
      error(@host.hostname, "Puppet Enterprise uninstall failed.")
      return
    end
  end

  def name
    :uninstall_pe
  end

  def description
    "Uninstall and purge all traces of PE."
  end
end
