require 'installer/action'
require 'installer/errors'

class Installer::Planner::Step::VerifyMCO < Installer::Planner::Step
  def initialize(infra, data={}, pre=nil, post=nil)
    super

  end

  def perform_step(&execute)
    host = @infra.find_hosts_with_roles([:master]).first
    mcotest = Installer::Action::Execute.new(:host => host, :sudo => true, :cmd => "su peadmin -c '/opt/puppetlabs/puppet/bin/mco find'")
    yield mcotest

    if mcotest.success?
      stdout = mcotest.results[host.hostname][:stdout]
      found = []
      @infra.hosts.each do |mcohostname, mcohost|
        if Regexp.new(Regexp.escape(mcohostname)).match stdout
          found << mcohostname
        end
      end

      if found.empty?
        warning(host.hostname, @t.step.verify_mco.no_hosts)
      end
    else
      warning(host.hostname, @t.step.verify_mco.mco_failed)
    end
  end

  def name
    :verify_mcollective
  end

  def description
    @t.step.verify_mco.description(hosts: @infra.hosts.keys.join(', '))
  end
end
