require 'erb'
require 'securerandom'

class Installer::Role
  attr_accessor :host, :certname, :requires, :outbound, :inbound, :installed_services

  def initialize(config)
    @outbound = config[:outbound] || []
    @inbound = config[:inbound] || []
    @installed_services = []
  end

  def answers_hash(hash)
    raise 'Cannot generate answers from role without a parent host.' unless @host
    hash
  end

  def name
    raise 'Not Implemented: Roles must define a name.'
  end
end
