require 'installer/role'
require 'installer/common'

class Installer::Role
  class Agent < Installer::Role
    attr_reader :master_hostname, :agent_certname

    def initialize(config={})
      super(config)
      @master_hostname = config[:master_hostname]
      @agent_certname = config[:agent_certname]
      @master_lookup = config[:master_lookup] || true
      @outbound << {role: :master, port: 8140}
      @outbound << {role: :master, port: 61613}
      @installed_services << "pe-puppet"
      @installed_services << "pe-mcollective"
    end

    def answers_hash
      hash = super({})
      hash.merge!({
        'q_fail_on_unsuccessful_master_lookup' => true_false_to_yn(@master_lookup),
        'q_puppetagent_certname' => @agent_certname,
        'q_puppetagent_install' => 'y',
        'q_puppetagent_server' => @master_hostname,
        'q_skip_master_verification' => 'n',
      })
    end

    def name
      :agent
    end
  end
end
