require 'installer/role'
require 'installer/common'

class Installer::Role::Console < Installer::Role
  attr_accessor :username, :password, :port, :public_hostname, :master_hostname
  attr_accessor :puppetdb_db

  def initialize(config={})
    super(config)
    @master_certname = config[:master_certname]
    @master_hostname = config[:master_hostname]
    @password = config[:password]
    @port = config[:port] || 443
    @public_hostname = config[:public_hostname]
    @puppetdb_db = config[:puppetdb_db]
    @rbac_db = config[:rbac_db]
    @classifier_db = config[:classifier_db]
    @activity_db = config[:activity_db]
    @orchestrator_db = config[:orchestrator_db]
    @puppetdb_hostname = config[:puppetdb_hostname]
    @puppetdb_port = config[:puppetdb_port] || 8081
    @requires = [:master, :puppetdb]
    @inbound << {role: :master, port: 443}
    @inbound << {role: :master, port: @port}
    @outbound << {role: :master, port: 8140}
    @outbound << {role: :puppetdb, port: @puppetdb_port}
    @installed_services << "pe-memcached"
    @installed_services << "pe-puppet-dashboard-workers"
    @installed_services << "pe-console-services"
    @use_application_services = config[:use_application_services]
  end

  def answers_hash
    hash = super({})
    hash.merge!(
      'q_database_host' => @rbac_db.hostname,
      'q_database_port' => @rbac_db.port,
      'q_pe_database' => true_false_to_yn(@rbac_db.pe_managed),
      'q_public_hostname' => @public_hostname || @host.hostname,
      'q_puppet_enterpriseconsole_auth_password' => @password,
      'q_puppet_enterpriseconsole_httpd_port' => @port,
      'q_puppet_enterpriseconsole_install' => 'y',
      'q_puppet_enterpriseconsole_master_hostname' => @master_hostname || @host.hostname,
      'q_puppetdb_database_name' => @puppetdb_db.name,
      'q_puppetdb_database_password' => @puppetdb_db.password,
      'q_puppetdb_database_user' => @puppetdb_db.username,
      'q_classifier_database_name' => @classifier_db.name,
      'q_classifier_database_user' => @classifier_db.username,
      'q_classifier_database_password' => @classifier_db.password,
      'q_rbac_database_name' => @rbac_db.name,
      'q_rbac_database_user' => @rbac_db.username,
      'q_rbac_database_password' => @rbac_db.password,
      'q_activity_database_name' => @activity_db.name,
      'q_activity_database_user' => @activity_db.username,
      'q_activity_database_password' => @activity_db.password,
      'q_orchestrator_database_name' => @orchestrator_db.name,
      'q_orchestrator_database_user' => @orchestrator_db.username,
      'q_orchestrator_database_password' => @orchestrator_db.password,
      'q_puppetdb_hostname' => @puppetdb_hostname,
      'q_puppetdb_port' => @puppetdb_port,
      'q_puppetmaster_certname' => @master_certname,
      'q_use_application_services' => true_false_to_yn(@use_application_services)
    )
  end

  def name
    :console
  end
end
