require 'installer/role'
require 'installer/common'

class Installer::Role::Master < Installer::Role
  attr_accessor :check_for_updates

  def initialize(config={})
    super(config)
    @all_in_one = config[:all_in_one]
    @cert_name = config[:cert_name]
    @puppetdb_hostname = config[:puppetdb_hostname]
    @puppetdb_port = config[:puppetdb_port] || 8081
    @console_hostname = config[:console_hostname]
    @console_port = config[:console_port] || 443
    @orchestrator_db = config[:orchestrator_db]
    @check_for_updates = config[:check_for_updates] || true
    @inbound << {role: :agent, port: 8140}
    @inbound << {role: :agent, port: 61613}
    @inbound << {role: :console, port: 8140}
    @outbound << {role: :puppetdb, port: @puppetdb_port}
    @outbound << {role: :console, port: @console_port}
    @installed_services << "pe-activemq"
    @installed_services << "pe-mcollective"
    @installed_services << "pe-puppetserver"
  end

  def answers_hash
    hash = super({})
    hash.merge!(
      'q_database_host' => @orchestrator_db.hostname,
      'q_database_port' => @orchestrator_db.port,
      'q_all_in_one_install' => true_false_to_yn(@all_in_one),
      'q_pe_check_for_updates' => true_false_to_yn(@check_for_updates),
      'q_puppetdb_hostname' => @puppetdb_hostname,
      'q_puppetdb_port' => @puppetdb_port,
      'q_puppetmaster_certname' => @cert_name,
      'q_puppetmaster_dnsaltnames' => @host.alt_names.join(','),
      'q_puppetmaster_enterpriseconsole_hostname' => @console_hostname,
      'q_puppetmaster_enterpriseconsole_port' => @console_port,
      'q_puppetmaster_install' => 'y',
      'q_orchestrator_database_name' => @orchestrator_db.name,
      'q_orchestrator_database_user' => @orchestrator_db.username,
      'q_orchestrator_database_password' => @orchestrator_db.password,
    )
  end

  def name
    :master
  end
end
