require 'installer/role'

class Installer::Role::Postgres < Installer::Role
  attr_reader :port, :user, :password

  def initialize(config={})
    super(config)
    @port = config[:port] || 5432
    @user = config[:user] || 'root'
    @password = config[:password]
    @database = {}
    @inbound << {role: :console, port: @port}
    @inbound << {role: :puppetdb, port: @port}
    @inbound << {role: :master, port: @port}
    @installed_services << "pe-postgresql"
  end

  def add_database(db_name, database_service)
    @database[db_name] = database_service
  end

  def database(name)
    @database[name]
  end

  def answers_hash
    hash = super({})

    hash.merge!(
      'q_database_host' => @host.hostname,
      'q_database_install' => 'y',
      'q_database_port' => @port,
      'q_database_root_password' => @password,
      'q_database_root_user' => @user,
      'q_pe_database' => 'y'
    )

    if @database.include? 'puppetdb'
      hash.merge!(
        'q_puppetdb_database_name' => @database['puppetdb'].name,
        'q_puppetdb_database_user' => @database['puppetdb'].username,
        'q_puppetdb_database_password' => @database['puppetdb'].password
      )
    end

    if @database.include? 'classifier'
      hash.merge!(
        'q_classifier_database_name' => @database['classifier'].name,
        'q_classifier_database_user' => @database['classifier'].username,
        'q_classifier_database_password' => @database['classifier'].password
      )
    end

    if @database.include? 'rbac'
      hash.merge!(
        'q_rbac_database_name' => @database['rbac'].name,
        'q_rbac_database_user' => @database['rbac'].username,
        'q_rbac_database_password' => @database['rbac'].password
      )
    end

    if @database.include? 'activity'
      hash.merge!(
        'q_activity_database_name' => @database['activity'].name,
        'q_activity_database_user' => @database['activity'].username,
        'q_activity_database_password' => @database['activity'].password
      )
    end

    if @database.include? 'orchestrator'
      hash.merge!(
        'q_orchestrator_database_name' => @database['orchestrator'].name,
        'q_orchestrator_database_user' => @database['orchestrator'].username,
        'q_orchestrator_database_password' => @database['orchestrator'].password
      )
    end

    hash
  end

  def name
    :postgres
  end
end
