require 'installer/role'
require 'installer/common'

class Installer::Role::PuppetDB < Installer::Role
  attr_accessor :port, :plaintext_port, :db

  def initialize(config={})
    super(config)
    @master_certname = config[:master_certname]
    @console_certname = 'pe-internal-dashboard'
    @port = config[:port] || 8081
    @plaintext_port = config[:plaintext_port] || 8080
    @puppetdb_db = config[:puppetdb_db]
    @rbac_db = config[:rbac_db]
    @classifier_db = config[:classifier_db]
    @activity_db = config[:activity_db]
    @requires = [:master]
    @inbound << {role: :master, port: @port}
    @inbound << {role: :console, port: @port}
    @installed_services << "pe-puppetdb"
  end

  def answers_hash
    hash = super({})
    hash.merge!(
      'q_database_host' => @puppetdb_db.hostname,
      'q_database_install' => true_false_to_yn(@puppetdb_db.hostname == @host.hostname),
      'q_database_port' => @puppetdb_db.port,
      'q_puppetdb_database_name' => @puppetdb_db.name,
      'q_puppetdb_database_password' => @puppetdb_db.password,
      'q_puppetdb_database_user' => @puppetdb_db.username,
      'q_classifier_database_name' => @classifier_db.name,
      'q_classifier_database_user' => @classifier_db.username,
      'q_classifier_database_password' => @classifier_db.password,
      'q_rbac_database_name' => @rbac_db.name,
      'q_rbac_database_user' => @rbac_db.username,
      'q_rbac_database_password' => @rbac_db.password,
      'q_activity_database_name' => @activity_db.name,
      'q_activity_database_user' => @activity_db.username,
      'q_activity_database_password' => @activity_db.password,
      'q_puppetdb_hostname' => @host.hostname,
      'q_puppetdb_install' => 'y',
      'q_puppetdb_plaintext_port' => @plaintext_port,
      'q_puppetdb_port' => @port,
      'q_puppetmaster_certname' => @master_certname
    )
  end

  def name
    :puppetdb
  end
end
