class Installer::Subscribers
  attr_reader :subscribers

  def initialize(logger)
    @logger = logger
    @subscribers = []
  end

  def add(subscriber)
    @subscribers.push(subscriber)
  end

  def remove(subscriber)
    @subscribers.delete(subscriber)
  end

  def publish(event)
    event.log(@logger)
    @subscribers.each do |out|
      out << event.to_publish_s
    end
  end
end
