# frozen_string_literal: true

# Starts a block of code in parallel with the main plan without blocking.
# Returns a Future object.
#
# > **Note:** Not available in apply block
Puppet::Functions.create_function(:background, Puppet::Functions::InternalFunction) do
  # Starts a block of code in parallel with the main plan without blocking.
  # Returns a Future object.
  # @param name An optional name for legible logs.
  # @param block The code block to run in the background.
  # @return A Bolt Future object
  # @example Start a long-running process
  #   background() || {
  #     run_task('superlong::task', $targets)
  #   }
  #   run_command("echo 'Continue immediately'", $targets)
  dispatch :background do
    scope_param
    optional_param 'String[1]', :name
    block_param 'Callable[0, 0]', :block
    return_type 'Future'
  end

  def background(scope, name = nil, &block)
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(
          Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING,
          action: 'background'
        )
    end
    raise Puppet::Error, "background is currently not supported in PE plans"
  end
end