module PeBackupTools
  module Utils
    # This module provides utilities to summarize the output of pbr commands
    module CommandSummary
      def self.summarize_create(info)
        if info[:status] == 'success'
          puts ''
          # TODO: Should we put the digest and the runtime total in here?
          scope_string = info[:scope].map { |s| "'#{s}'" }.join(', ').chomp
          puts _('Success! Backup of %{scope} is %{size}.') % { scope: scope_string, size: PeBackupTools::Utils.humanize_size(info[:size]) }
          puts ''
          puts info[:filename]
          puts ''
          puts _('Move your backup to another location.') + ' ' + _('Be sure to keep your backups in a secure, centralized location that is not on the primary.')
          puts ''
        else
          puts _('Fatal error! Backup failed:')
          puts ''
          puts info[:error_description]
          puts ''
          puts _('See %{logfile} for more information.') % { logfile: info[:logfile] }
        end
      end

      def self.summarize_restore(info)
        if info[:status] == 'success'
          puts ''
          puts _('Backup restored.')
          puts '  ' + _('Time to restore: %{time}') % { time: PeBackupTools::Utils.humanize_time(info[:runtime][:total]) }
          puts '  ' + _('Size: %{size}, Scope: %{scope}') % { size: PeBackupTools::Utils.humanize_size(info[:size]), scope: info[:scope].join(', ').chomp }
          puts ''
          puts 'To finish restoring your primary server from backup, run the following commands:'
          if info[:r10k_remote] && !info[:r10k_remote].empty?
            puts 'puppet access login'
            puts 'puppet code deploy --all --wait'
            puts 'puppet agent -t'
            puts 'puppet agent -t'
            if info[:preexisting_replica]
              puts "puppet infrastructure forget #{info[:preexisting_replica].first}"
              puts ''
            end
          else
            puts 'puppet agent -t'
          end
        else
          puts _('Fatal error! Restore failed:')
          puts info[:error_description]
          puts ''
          puts _('See %{logfile} for more information.') % { logfile: info[:logfile] }
        end
      end
    end
  end
end
