require 'hocon/parser/config_document_factory'
require 'hocon/config_error'
require 'hocon/config_value_factory'
require 'json'

module PeBackupTools
  module Utils
    # This module provides utility functions for the overall install command
    # Contains methods to generate/merge pe.conf content, as well as helpers for Hocon functionality
    module ConfFiles
      def self.hocon_assoc(object, key, value)
        object.set_config_value("\"#{key}\"", Hocon::ConfigValueFactory.from_any_ref(value))
      end

      def self.hocon_merge(object, hash)
        hash.each do |key, value|
          object = hocon_assoc(object, key, value)
        end
        object
      end
    end
  end
end
