# Puppet Enterprise Management Tools

This repository is one of several that comprise the tooling used to manage
installations of Puppet Enterprise.

The index of repositories and documentation for these tools is at
[puppetlabs/pe_installer](https://github.com/puppetlabs/pe_installer).

# enterprise_tasks

A collection of tasks for the installation, management, and configuration of Puppet Enterprise.

[PE-23295 Tracking ticket for Installer and Management team's efforts](https://tickets.puppetlabs.com/browse/PE-23295)

#### Table of Contents

1. [Description](#description)
2. [Setup - The basics of getting started with enterprise_tasks](#setup)
3. [Usage - Configuration options and additional functionality](#usage)
4. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
    * [Plans](#plans)
      * [Base Modulepath Plans](#base-modulepath-plans)
      * [Helper Plans](#helper-plans)
      * [Testing Plans](#testing-plans)
5. [Limitations - OS compatibility, etc.](#limitations)
6. [Development - Guide for contributing to the module](#development)

## Description

This Bolt module provides a variety of tasks for PE-related operations. See
[Reference](#reference) below for a list of plans (or bolt plan show once you
are setup). Of course, the individual tasks that make up each of those plans
are also available.

The module is shippped in PE as part of the
[pe-installer](https://github.com/puppetlabs/pe-installer-vanagon) package.

## Setup

First, this requires having an installation of Bolt. Steps for installing Bolt
can be found in the [Bolt
Documentation](https://puppet.com/docs/bolt/1.x/bolt_installing.html).

To use this module, you can add it as a dependency into your Bolt
installation's default Puppetfile, or you can add it into a Puppetfile in your
own custom Boltdir.

```
mod 'enterprise_tasks', git: 'git@github.com:puppetlabs/enterprise_tasks.git'
```

If you would like to create a custom Boltdir, you first need to create a
`bolt.yaml` file in the directory which you'd like to use for the Boltdir.
Then, you can specify the modules you would like your Boltdir to have by
creating a Puppetfile in that same directory. Then, you can call `bolt
puppetfile install --boltdir <path-to-boltdir>` to install your specified
modules into your Boltdir. Then your tasks/plans can be run by calling `bolt
--boltdir <path-to-boltdir> task run <task>` or `bolt --boltdir
<path-to-boltdir> plan run <plan>`

If you're interested in cloning this repo to use it as a module, rather than
having it as a dependency in a Puppetfile, you should be able to clone the repo
into either `$HOME/.puppetlabs/bolt/site` or clone it into
`<path-to-custom-boltdir>/site`. You can also include it as a local module in
your Puppetfile (`mod 'enterprise_tasks', local: true`) and copy it directly
into the boltdir's `modules` directory.

## Usage

If this module is installed into the default Boltdir:

To show available tasks: `bolt task show`

To show available plans: `bolt plan show`

To run a task: `bolt task run enterprise_tasks::<name_of_task> <parameters>`

To run a plan: `bolt plan run enterprise_tasks::<name_of_plan> <parameters>`

If using a custom Boltdir, you need to use the `--boltdir <path-to-boltdir>` flag with the above commands to allow Bolt to recognize your modules.

The module has a Puppetfile, so you will need to ensure that these dependencies are installed.

To use the testing install/upgrade plans see [Testing Plans](#testing-plans) below.

### Tasks and Plans via PCP

This section contains results and relevant information from a spike into using PCP to run the various tasks and plans from this repo. This section is just to represent a somewhat hacky and temporary approach to running plans with PCP (pending a better solution once the work on Plans in PE is completed). `puppet infra run` can be used to invoke these commands when in a PE environment.

#### Using Tasks with PCP

##### Setup

* Certain Bolt actions require extra dependency modules
  - For built-in Bolt tasks, as well as `run_command` invocations in plans to work: the bolt_shim module is necessary, and should be available in /opt/puppetlabs/puppet/modules
  - For apply() to work (again plan-only, but it's in the tasks section because I don't want to just repeat this below...): the apply_helpers module is required and should be available in /opt/puppetlabs/puppet/modules

##### General Information

* It is relatively straightforward to get most tasks up and running via `puppet infra run` invocations
* Many, if not all, of our custom enterprise_tasks tasks work without needing to use any extra modules
* `puppet task` needs to be able to pick up whatever enterprise_tasks task we want to run
  - This can be done mostly simply by moving our enterprise_tasks module into /opt/puppetlabs/puppet/modules. As a side note, it would be nice to hide basically all of these tasks from the console when doing this (most are not particularly useful to a user, and I believe that most of the individual tasks are not). Clashing with other already-installed modules is a real concern if we need to take this approach in the future when actually adding support for PCP outside of manual hacking
* For dependency modules, only modules that tasks directly require need to be added to the puppet module directory (i.e. ruby_task_helper, in the case of basically all of our tasks)
* To actually run via PCP: pass in `--transport pcp` when invoking a task, or pass in the nodes you'd like the task to run against like so: `pcp://<puppet_certname>`

#### Using Plans with PCP

##### Setup

* Setup requirements are identical to running tasks: see "Setup" above
* Invocation is the same as above and can be done by using `--transport pcp` in a plan call or appending `pcp://` to any nodes passed to the plan

##### Potential Stumbling Blocks

* Having dependencies on non-task files (i.e. dependencies on certain puppet-enterprise-modules files) is a pain 
* More investigation may be required, but the way we currently specify dependencies on puppet-enterprise-modules files for Bolt via `puppet infra run` does not work for running tasks via PCP (although there's one case where our dependencies will get picked up: when a task is literally running on "localhost")
  - This does not necessarily mean that it's not possible to provide these dependency files correctly; just that we will need to do it differently than how we currently do it for Bolt (which means that we may need clear differentiation between what tasks run on PCP only and what things do not, because the structuring of dependencies may be programatically different)
  - The upcoming Plans in PE work by Team Skeletor may cause this bullet point to be irrelevant and/or change
* Plans that stop various services that the orchestrator interacts with (like pe-puppetserver) will break this, but that's probably unavoidable

## Reference

### Plans

Use `bolt plan show` for the most current listing.

Not every plan is necessarily in use in a PE install.

The `puppet infra run` action includes certain plans for use in PE. (see the
[pe_manager run
action](https://github.com/puppetlabs/puppet-enterprise-modules/blob/irving/modules/pe_manager/lib/puppet/face/infrastructure/run.rb))

#### Base Modulepath Plans
##### agent_cert_regen.pp

Used to regenert Puppet agent certicates.
This plan can be called from commandline as below
```
$bolt plan run enterprise_tasks::agent_cert_regen --params '{ "agent":<agent>, "caserver":<caserver>, "dns_alt_names":"dns-alt-name-1,dns-alt-name-2", "extension_requests":{"pp_role":"webserver"}, "custom_attributes":{"challengePassword":"S3cr3tP@ssw0rd"}}'
```

##### convert_legacy_compiler.pp

Converts a compiler from the legacy type that only included Puppet Server, to one that also includes the PuppetDB service.

##### enable_ha_failover.pp

An HA helper plan, used to repurpose a failed primary as a replica after a replica has been promoted.

##### primary_cert_regen.pp

Used to regenerate the PE primary's certificate, helpful if the primary is renamed.
This plan can be called from commandline as below:
```
$bolt plan run enterprise_tasks::primary_cert_regen --params '{ "primary":"<primaryhost>", "dns_alt_names":"dns-alt-name-1,dns-alt-name-2", "extension_requests":{"pp_role":"webserver"}, "custom_attributes":{"challengePassword":"S3cr3tP@ssw0rd"} }'
```

##### rebuild_ca.pp

Used to rebuild the Puppetserver's entire Certificate Authority.

#### Helper plans

Plans used by other plans.

##### create_tempdirs.pp

Uses mktemp to generate unique working directories on all targets. Stores the
path to the directory as a variable 'workdir' on each target.

##### sync_enterprise_data.pp

Used to recover configuration on primary and sync it (user_data.conf and
nodes/\*) to a list of other infrastructure nodes.

Currently this plan is only used by the testing/upgrade_pe plan. It is not
clever enough to figure out what the rest of the infrastructure is from the
data it recovers, but could be improved to do so if necessary.

#### Testing Plans

The plans/testing/\* plans are intended for use in internal testing pipelines.

They are intended to be equally useful for manual testing. If you are set up to
run plans from this module on your workstation, then once you have vms checked
out, you should be able to run any of these plans to create a pe.conf, get a PE
tarball on to the nodes, or install as needed.

To get started from an isolated local checkout it's probably easiest to add the
module to the default Puppetfile as described in [setup](#setup) above.

So as an example with a fresh vm, you can use these steps:

Check out an el7 vm (using [floaty](https://github.com/briancain/vmfloaty) for example).

Make sure and shell in with ssh-agent forwarding!

`ssh -A root@<newvm>`

```sh
# assumes root login
rpm -Uvh https://yum.puppet.com/puppet6-release-el-7.noarch.rpm
yum install -y puppet-bolt git

# Add an entry for github to known hosts so we don't get asked whether to accept key
echo "github.com,192.30.255.112 ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEAq2A7hRGmdnm9tUDbO9IDSwBK6TbQa+PXYPCPy6rbTrTtw7PHkccKrpp0yVhp5HdEIcKr6pLlVDBfOLX9QUsyCOV0wzfjIJNlGEYsdlLJizHhbn2mUjvSAHQqZETYP81eFzLQNnPHt4EVVUh7VfDESU84KezmD5QlWpXLmvU31/yMf+Se8xhHTvKSCZIFImWwoG6mbUoWf9nzpIoaSjB+weqqUUmpaaasXVal72J+UX2B+2RPW3RcT0eOzQgqlJL3RKrTJvdsjE3JEAvGq3lGHSZXy28G3skua2SmVi/w4yCE6gbODqnTWlg7+wC604ydGXA8VJiS5ap43JXiUFFAaQ==" >> "${HOME}/.ssh/known_hosts"

mkdir -p ~/.puppetlabs/bolt
echo "mod 'enterprise_tasks', git: 'git@github.com:puppetlabs/enterprise_tasks.git'" > ~/.puppetlabs/bolt/Puppetfile
bolt puppetfile install
bolt plan show
```

---

For resetting nodes:

`bolt command run '/opt/puppetlabs/bin/puppet-enterprise-uninstaller -y -d -p' -n [node,list]`

seemed simple enough to not be worth a plan of its own.

##### install

This plan orchestrates installation of primary and secondary infrastructure. It
uses install_pe to setup PE in whatever configuration you specify (based on the
hostnames given for primary, database, etc.), and can be used to install
replicas as well.

It configures code manager which is required for replica.

The plan will be expanded for compilers in the future. See
[install.pp](plans/testing/install.pp) for edetails

##### create_pe_conf

Generates a basic pe.conf suitable for initial installtion given a few key
parameters with optional overrides. See
[create_pe_conf.pp](plans/testing/create_pe_conf.pp) for details.

##### get_pe

Downloads and unpacks a PE tarball for the correct platform on some set of
nodes. Must be able to reach artifactory.delivery.puppetlabs.net, unless you are
uploading a tarball that you have built locally (with say,
[frankenbuilder](https://github.com/puppetlabs/frankenbuilder)).

See [get_pe.pp](plans/testing/get_pe.pp) for details.

##### install_pe

Handles installation of PE in CI for all layouts. See
[installe_pe.pp](plans/testing/install_pe.pp) for details.

##### run_installer

Runs the puppet-enterprise-installer on a node. Returns the installer log on
failure. See [run_installer.pp](plans/testing/install_pe.pp) for details.

##### upgrade_pe

Handles upgrade of PE in CI for all layouts. SEE
[upgrade_pe.pp](plans/testing/install_pe.pp) for details

## Limitations

This module is shipped with the pe-installer package, and is intended for use with PE installations from 2018.1.x forward.

## Development

### Testing

Run:

`bundle exec rake test`

to run all of the test targets.

There is a validate_plans target which can be run to get `puppet parser
validate --tasks` feedback for all the plans.

## Contributing

Fork the module, submit pull requests, please ensure that tests are passing and
new tests are added where appropriate.

Commit messages should follow standard Puppet practice. The header should start
with a (TICKET-1234) reference or (maint). Commit messages should provide a
summary of what the problem was, what you changed and how the change fixes the
problem. Typos are an obvious exception.
