# Find out which role a node has based on profiles/facts applied to the node.
# This function does not support legacy splits with separate console and
# puppetdb nodes, and will return the wrong thing in these installations.
function enterprise_tasks::get_node_role(TargetSpec $node){
  $target = get_target($node)
  # In case we were passed 'localhost'
  $certname = enterprise_tasks::get_certname($target.host)

  if enterprise_tasks::node_has_profile($certname, 'primary_master_replica') {
    return 'replica'
  }

  if enterprise_tasks::node_has_profile($certname, 'pe_compiler') {
    return 'pe_compiler'
  }

  if enterprise_tasks::node_has_profile($certname, 'master') {
    if enterprise_tasks::node_has_profile($certname, 'console') {
      return 'primary'
    } else {
      return 'legacy_compiler'
    }
  } else {
    if enterprise_tasks::node_has_profile($certname, 'database') {
      return 'external_postgres'
    }
  }

  if !enterprise_tasks::node_has_pe_packages($certname) {
    return 'non_infra_agent'
  }

  return 'unknown'
}