#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'

class EnableAgent < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper
  def task(**_kwargs)
    cmd = [puppet_bin, 'config', 'print', 'certname']
    certname = Open3.capture2e(*cmd)[0].strip
    puppet_cmd = [puppet_bin, 'agent', '--enable']
    output, status = Open3.capture2e(*puppet_cmd)
    raise EnterpriseTaskHelper::Error.new("Could not enable puppet agent on #{certname}. Please run 'puppet agent --enable' manually to re-enable the agent.", 'puppetlabs.enable-agent/enable-agent-failure', 'output' => output) unless status.exitstatus.zero?
  end
end

EnableAgent.run if __FILE__ == $PROGRAM_NAME
