#!/opt/puppetlabs/puppet/bin/ruby

require_relative '../files/enterprise_task_helper.rb'
require 'open3'
require 'yaml'

class GetPackageVersion < EnterpriseTaskHelper
  def task(package:, **_kwargs)
    output, _stderr, status = YAML.load(Open3.capture3("/opt/puppetlabs/bin/puppet resource --to_yaml package #{package}")[0].strip)
    raise EnterpriseTaskHelper::Error.new("#{package} is not installed", 'puppetlabs.get-package-version/puppet-config-error', 'output' => output) if output['package']["#{package}"]['ensure'] == 'purged'

    { version: output['package']["#{package}"]['ensure'] }
  end
end

GetPackageVersion.run if __FILE__ == $PROGRAM_NAME
