#!/opt/puppetlabs/puppet/bin/ruby

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class GetSubjectAltNames < EnterpriseTaskHelper
  def task(**_kwargs)
    output, _stderr, status = Open3.capture3('/opt/puppetlabs/bin/puppet config print dns_alt_names --section agent')
    raise EnterpriseTaskHelper::Error.new('Error getting dns_alt_names', 'puppetlabs.get-subject-alt-names/puppet-config-error', 'output' => output) if !status.exitstatus.zero?

    result = output.chomp.split(',')
    result = nil if result.empty?
    { altnames: result }
  end
end

GetSubjectAltNames.run if __FILE__ == $PROGRAM_NAME
