# Ensure that the primary's ssldir is owned by pe-puppet.  This is a requirement
# for a puppetserver ca, but is not handled by packaging.  Puppet itself, when
# run on the commandline will set ssldir permissions, but expecting that to
# occur at the right time as a side effect of our command line calls from
# pe_install::prepare::certificates is brittle and error prone.
class pe_install::install::ssldir {

  $target_dir = '/etc/puppetlabs/puppet/ssl'
  $owner      = 'pe-puppet'
  $group      = 'pe-puppet'

  #This is the same exec used in pe_repo::set_owner_group_permissions
  exec { "Set user/group of ${target_dir} contents to ${owner}:${group}":
    command   => "find ${target_dir}/ \\( ! -user ${owner} -or ! -group ${group} \\) -exec chown ${owner}:${group} -c {} \\;",
    onlyif    => "find ${target_dir}/ \\( ! -user ${owner} -or ! -group ${group} \\) | grep '.*'",
    path      => $facts['path'],
    logoutput => true,
    loglevel  => 'info',
    before    => Service['pe-puppetserver'],
    require   => Package['pe-puppetserver'],
  }
}
