# Ensures PE specific settings in the node's puppet.conf and associates the
# node with the primary.
class pe_install::prepare::puppet_config {

  $puppet_conf_file = '/etc/puppetlabs/puppet/puppet.conf'

  $main_settings = {
    'certname'            => $facts['clientcert'],
    'server'              => $::pe_install::master_certname,
    'user'                => 'pe-puppet',
    'group'               => 'pe-puppet',
  }

  $main_settings.each |String $setting, $value| {
    pe_ini_setting { "main/${setting}":
      ensure  => present,
      section => 'main',
      setting => $setting,
      value   => $value,
      path    => $puppet_conf_file,
    }
  }

  $agent_settings = {
    'graph' => true,
  }

  $agent_settings.each |String $setting, $value| {
    pe_ini_setting { "agent/${setting}":
      ensure  => present,
      section => 'agent',
      setting => $setting,
      value   => $value,
      path    => $puppet_conf_file,
    }
  }
}
