class pe_repo::platform::aix_power(
  $agent_version = $facts['aio_agent_version'],
){
  include pe_repo

  # Maintain backwards compatibilty with older agent versions
  $pe_repo_name = versioncmp($agent_version, '6.19.1') ? {
    1       => '7.1',
    default => '6.1',
  }

  unless defined(Pe_repo::Aix["aix-${pe_repo_name}-power"]){
    pe_repo::aix { "aix-${pe_repo_name}-power":
      agent_version =>  $agent_version,
      pe_version =>  $pe_repo::default_pe_build,
    }
  }
}
