# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`pe_status_check`](#pe_status_check): This class should be enabled if you wish Puppet to notify when pe_status_check indicators are not at optimal values
* [`pe_status_check::agent_status_enable`](#pe_status_checkagent_status_enable): Enables the execution of agent_status_check fact

### Plans

* [`pe_status_check::agent_summary`](#pe_status_checkagent_summary): Summary report if the state of agent_status_check on each node
Uses the facts task to get the current status from each node
and produces a summary report in JSON
* [`pe_status_check::infra_summary`](#pe_status_checkinfra_summary): Summary report if the state of pe_status check on each node
Uses the facts task to get the current status from each node
and produces a summary report in JSON

## Classes

### <a name="pe_status_check"></a>`pe_status_check`

When this class is enabled, when any of the indicators in the pe_status_check fact are false puppet will notify of this,
 individual tests can be disabled by adding the ID to the indicator_exclusions parameter

#### Examples

##### 

```puppet
include pe_status_check
```

#### Parameters

The following parameters are available in the `pe_status_check` class:

* [`indicator_exclusions`](#indicator_exclusions)

##### <a name="indicator_exclusions"></a>`indicator_exclusions`

Data type: `Array[String[1]]`

List of disabled indicators, place any indicator ids you do not wish to report on in this list

Default value: `[]`

### <a name="pe_status_checkagent_status_enable"></a>`pe_status_check::agent_status_enable`

Adding this class will enable the execution of the agent_status_check fact,
This allows the fact to be targeted to a specific agent or group of agents

#### Examples

##### 

```puppet
include pe_status_check::agent_status_enable
```

#### Parameters

The following parameters are available in the `pe_status_check::agent_status_enable` class:

* [`agent_status_enabled`](#agent_status_enabled)

##### <a name="agent_status_enabled"></a>`agent_status_enabled`

Data type: `Boolean`

Flag to enable or disable agent_status_check fact

Default value: ``true``

## Plans

### <a name="pe_status_checkagent_summary"></a>`pe_status_check::agent_summary`

Summary report if the state of agent_status_check on each node
Uses the facts task to get the current status from each node
and produces a summary report in JSON

#### Parameters

The following parameters are available in the `pe_status_check::agent_summary` plan:

* [`targets`](#targets)
* [`indicator_exclusions`](#indicator_exclusions)

##### <a name="targets"></a>`targets`

Data type: `Optional[TargetSpec]`

A comma seprated list of FQDN's of Puppet agent nodes
Defaults to using a PuppetDB query to identify nodes

Default value: ``undef``

##### <a name="indicator_exclusions"></a>`indicator_exclusions`

Data type: `Array[String[1]]`

List of disabled indicators, place any indicator ids you do not wish to report on in this list

Default value: `[]`

### <a name="pe_status_checkinfra_summary"></a>`pe_status_check::infra_summary`

Summary report if the state of pe_status check on each node
Uses the facts task to get the current status from each node
and produces a summary report in JSON

#### Parameters

The following parameters are available in the `pe_status_check::infra_summary` plan:

* [`targets`](#targets)
* [`indicator_exclusions`](#indicator_exclusions)

##### <a name="targets"></a>`targets`

Data type: `Optional[TargetSpec]`

A comma seprated list of FQDN's of Puppet infrastructure agent nodes
Defaults to using a PuppetDB query to identify nodes

Default value: ``undef``

##### <a name="indicator_exclusions"></a>`indicator_exclusions`

Data type: `Array[String[1]]`

List of disabled indicators, place any indicator ids you do not wish to report on in this list

Default value: `[]`

