module Puppet::Parser::Functions
  newfunction(:pe_compile_master, :type => :rvalue, :doc => <<-EOS
    Returns whether or not the current node is a compiler.
    An optional input of the replication_mode parameter is accepted.
    Valid inputs: "none", "source", "replica", or nil. If replication
    mode is "source" or "replica", the function will always return false
    because that means the node is the MoM or replica, respectively.
    Otherwise it will return the result of certname == servername or 
    certname == primary.
  EOS
  ) do |args|
    # undef gets converted to "" in Puppet by lib/puppet/functions.rb
    valid_inputs = ["source", "replica", "none", nil, ""]
    not_compile_masters = ["source", "replica"]
    replication_mode = args.first
    mom_or_replica = false

    if args.length > 1 then
      raise Puppet::ParseError, ("pe_compile_master(): wrong number of arguments (#{args.length}; must be 0 or 1 if providing replication_mode)")
    end

    if args.length == 1 then
      if not valid_inputs.include? replication_mode
        raise Puppet::ParseError, "pe_compile_master(): invalid argument #{replication_mode}; must be one of 'source', 'replica', 'none', \"\", or nil"
      end
    end

    master = function_pe_getvar(['puppet_enterprise::puppet_master_host'])
    trusted = function_pe_getvar(['trusted'])
    if trusted.nil?
      raise Puppet::ParseError, ("pe_compile_master(): $trusted fact hash is required and expected to be set, but it was null")
    end
    certname = trusted['certname']
    servername = function_pe_servername([])
    if not_compile_masters.include?(replication_mode) || (certname == master)
      mom_or_replica = true
    end
    !(servername.nil? || mom_or_replica || servername == certname)

  end
end
