# Namespaced union function from puppetlabs-stdlib
# https://github.com/puppetlabs/puppetlabs-stdlib/blob/master/lib/puppet/parser/functions/union.rb

module Puppet::Parser::Functions
  newfunction(:pe_union, :type => :rvalue, :doc => <<-DOC
    This function returns a union of two or more arrays.
    *Examples:*
        pe_union(["a","b","c"],["b","c","d"])
    Would return: ["a","b","c","d"]
    DOC
             ) do |arguments|

    # Check that 2 or more arguments have been given ...
    raise(Puppet::ParseError, "pe_union(): Wrong number of arguments given (#{arguments.size} for < 2)") if arguments.size < 2

    arguments.each do |argument|
      raise(Puppet::ParseError, 'pe_union(): Every parameter must be an array') unless argument.is_a?(Array)
    end

    arguments.reduce(:|)
  end
end

# vim: set ts=2 sw=2 et :
