define puppet_enterprise::trapperkeeper::init_defaults(
  String  $container            = $title,
  String  $user                 = "pe-${container}",
  String  $group                = "pe-${container}",
  Integer $service_stop_retries = 60,
  Integer $start_timeout        = 300,
  Optional[String] $jruby_jar   = undef,
) {
  include puppet_enterprise::params

  $confdir = "/etc/puppetlabs/${container}"
  $installdir = "/opt/puppetlabs/server/apps/${container}"

  Pe_ini_setting {
    ensure  => present,
    path    => "${puppet_enterprise::params::defaults_dir}/pe-${container}",
    key_val_separator => '=',
    section => '',
    require => Package["pe-${container}"],
    notify  => Exec["pe-${container} service full restart"]
  }

  pe_ini_setting { "${container} initconf java_bin":
    setting => 'JAVA_BIN',
    value   => '"/opt/puppetlabs/server/bin/java"',
  }

  # Puppet Server distinguishes between JAVA_ARGS for ezbake services
  # and JAVA_ARGS_CLI other cli apps (eg. `puppetserver start`
  # to start the daemon vs `puppetserver gem` to run rubygems in JRuby.
  # Services and one off commands are tuned very differently and we allow users
  # to override JAVA_ARGS_CLI for adding custom configuration. Consequently in
  # a FIPS environment we have to directly manage the entropy generating device
  # source rather than combine it with the normal java args.
  if $facts['fips_enabled'] and $container == 'puppetserver' {
    pe_ini_setting { "${container} initconf sub_command_entropy":
      setting => 'CLI_TOOLS_EGD',
      value   => 'file:/dev/random',
    }
  }

  pe_ini_setting { "${container} initconf user":
    setting => 'USER',
    value   => $user,
  }

  pe_ini_setting { "${container} initconf group":
    setting => 'GROUP',
    value   => $group,
  }

  pe_ini_setting { "${container} initconf install_dir":
    setting => 'INSTALL_DIR',
    value   => "\"${installdir}\"",
  }

  pe_ini_setting { "${container} initconf config":
    setting => 'CONFIG',
    value   => "\"${confdir}/conf.d\"",
  }

  pe_ini_setting { "${container} initconf bootstrap_config":
    setting => 'BOOTSTRAP_CONFIG',
    value   => "\"${confdir}/bootstrap.cfg\"",
  }

  pe_ini_setting { "${container} initconf service_stop_retries":
    setting => 'SERVICE_STOP_RETRIES',
    value   => $service_stop_retries,
  }

  pe_ini_setting { "${container} initconf start_timeout":
    setting => 'START_TIMEOUT',
    value   => $start_timeout,
  }

  $jruby_jar_enabled = pe_empty($jruby_jar) ? {
    true    => 'absent',
    default => 'present',
  }

  pe_ini_setting { "${container} initconf jruby_jar":
    ensure => $jruby_jar_enabled,
    setting => 'JRUBY_JAR',
    value => "\"${jruby_jar}\"",
  }

  $java_share = '/opt/puppetlabs/share/java'
  $bc_jar_path = ($facts['fips_enabled']) ? {
    true => "${java_share}/bc-fips.jar:${java_share}/bcpkix-fips.jar:${java_share}/bctls-fips.jar",
    default => "${java_share}/bcprov-jdk18on.jar:${java_share}/bcpkix-jdk18on.jar:${java_share}/bcutil-jdk18on.jar"
  }

  pe_ini_setting { "${container} initconf bc_jar":
    setting => 'BC_JAR',
    value => "\"${bc_jar_path}\"",
  }
}
