[CmdletBinding()]
param(
  [Parameter(Mandatory = $true)]
  [String]
  $job_id
)

function Return-Error($kind, $message)
{
  Write-Host @"
{
  "_error"  : {
    "msg" : $message,
    "kind": $kind,
    "details" : {}
  }
}
"@

exit 1
}

function Get-ChildProcesses($process_id) {
  Get-CimInstance Win32_Process | Where-Object { $_.ParentProcessId -eq $process_id }
}

function Kill-ProcessTree($process_id) {
  Get-ChildProcesses $process_id | ForEach-Object { Kill-ProcessTree $_.ProcessId }
  Stop-Process -Id $process_id -Force
}

$spool_dir = "${env:ProgramData}\PuppetLabs\pxp-agent\var\spool"
$job_dir = "${spool_dir}\${job_id}"
$job_exists = Test-Path -Path $job_dir -PathType Container

if (!$job_exists) {
  Return-Error("kill-task/job-id-does-not-exist", "Job id ${job_id} does not exist")
}

$wrapper_pid = [int] (Get-Content "${job_dir}\pid")
$process = Get-Process -Id $wrapper_pid

# If the process doesn't exist or an exitcode file has been written, assume the
# job isn't running
$exitcode_exists = Test-Path -Path "${job_dir}\exitcode" -PathType Leaf
if (!$process -or $exitcode_exists) {
  Return-Error("kill-task/job-already-exited", "Cannot kill process, job ${job_id} already exited")
}

if ($process.ProcessName -ne 'execution_wrapper') {
  Return-Error("kill-task/job-already-exited", "Cannot kill process, the process name doesn't match what was expected")
}

# We don't kill the execution_wrapper directly, because we want it to stick
# around to clean up and report the exit status of the child.
Get-ChildProcesses $wrapper_pid | ForEach-Object { Kill-ProcessTree $_.ProcessId }

Write-Host @"
{ "kill_status": 1 }
"@
