# pe_install

#### Table of Contents

1. [Overview](#overview)
2. [Module Description - What the module does and why it is useful](#module-description)
3. [Setup - The basics of getting started with pe_install](#setup)
4. [Usage - Configuration options and additional functionality](#usage)
5. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
5. [Limitations - OS compatibility, etc.](#limitations)
6. [Development - Guide for contributing to the module](#development)

## Overview

The pe_install module is used by the `puppet enterprise` face to install,
upgrade and configure PE.  It depends on the
[puppet_enterprise](../puppet_enterprise)
module which does the bulk of the work.

## Module Description

This module is used by the
[pe_manager](../pe_manager) to determine
which of the puppet_enterprise::profiles should be applied and then include
them in the correct order.

It also handles classification of the console node, generating the [PE Node
Groups](https://docs.puppet.com/pe/latest/console_classes_groups_preconfigured_groups.html).

## Setup

The pe_install module is intended to be used by the pe_manager's `puppet
enterprise configure` action, which includes the `::pe_install` class.  It has
a hard dependency on the puppet_enterprise module (2016.2+).

## Usage

The base `::pe_install` class is the only class intended for external use.  In
order for it to take any action, it must receive profile certname parameters
that match with the local agent certname.

```puppet
class { '::pe_install':
  ca_certname       => 'this.host',
  master_certname   => 'this.host',
  puppetdb_certname => 'db.host',
  database_certname => 'db.host',
  console_certname  => 'console.host',
}
```

If applied on 'this.host', for example, the above would include the
certificate_authority and master profiles (along with orchestrator and
agent profiles which are all implied on the primary).

This parameters could (and typically would when using MEEP) be set in the
pe.conf hiera file as `::puppet_enterprise` host parameters.

## Reference

The ::pe_install class breaks activity into three sections:

* `::pe_install::validate` - currently a noop; intended to perform some sanity
  checking of disk space, ports, provided parameters, possibly external
  database connectivity.
* `::pe_install::prepare` - makes adjustments to the existing system (either the
  initial puppet-agent shim, or a system we are upgrading from) to prepare it
  for the puppet enterprise profiles.  Many of these were changes that used to be
  made by the legacy installer script, and may move into puppet_enterprise proper
  in the future.
* `::pe_install::install` - includes `::puppet_enterprise::profile::_role_` based
  on match of `::pe_install` certname parameters with the $::clientcert of the
  node.
* `::pe_install::install::classification` - creates/maintains the PE Node Groups
  in the classifier.

## Limitations

The pe_install module is intended for use on PE infrastructure platforms.

## Development

There is spec coverage testing the module behavior in conjunction with
puppet_enterprise on various host layouts.  The modulepath is set up in
spec/fixtures/modules by the rake task.

Specs can be run as follows:

    $ bundle install
    $ bundle exec rake spec

To make testing quicker you can have the modules preload:

    $ bundle exec rake spec_prep

And then:

    $ bundle exec rake spec_standalone

### Spec Organization

The module makes use of [rspec-puppet](http://rspec-puppet.com) 2.4, and
organizes the tests as that library expects, by classes and hosts. The
spec/fixtures library has the metadata needed for rspec-puppet to supply Puppet
with modules and the details of what to compile for a given set of specs.

#### spec/fixtures

The dependent modules are loaded into spec/fixtures/modules which rspec-puppet
uses as its modulepath.

The spec/fixtures/manifests/site.pp is the general entry point for hosts specs,
and provides a default node definition that simply includes pe_install, the
same as the pe_manager's puppet enterprise face does.  Other manifests in
spec/fixtures/manifests may be loaded via rspec-puppet's pre_condition() hook
when a custom manifest is required.

In general pe_install's behavior is modified entirely by the pe.conf hieradata,
which is provided in the module specs via spec/fixtures/hiera/hiera.yaml.  The
hiera.yaml provides a hierarchy of nodes/%{certname} and %{layout}.
The actual hiera yaml are in spec/fixtures/hiera/hieradata.

Layout is set as part of the 'hosts' shared_context provided in
spec/shared/contexts.rb.  Both mono and split are currently provided and may be
overridden with a let(:layout).  Layout is included as a fact, which is how it
ends up effecting the hiera hierarchy.  The certname fact ends up mapped to the
current :node helper value.

By using the run_with_custom_pe_conf() method from
spec/shared/custom_pe_conf.rb, you can generate a node specific pe.conf
hieradata file, whose parameters will take precedence over the :layout
, so long as the file matches the let(:node).

The intention is that each spec run from a single isolated hiera configuration
for clarity, so care should be taken that you don't specify both a layout and a
custom pe.conf for the node, unless that is deliberate.

#### spec/classes

Are used to verify individual classes in isolation.  Under the hood,
rspec-puppet includes the class.  Because of pe_install's structure, there is
little we can do with these completely in isolation, since most classes of
interest makes use of the $is_ca, $is_master, etc. variables defined in
init.pp.  So, compiling pe_install::install in isolation, compiles just fine
but doesn't end up including anything or doing much that can be tested.

This can be worked around to test a class in semi-isolation by using
pre_condition() to include pe_install with the base validate, prepare, install
classes stubbed, as is done in the
[certificates_spec](./spec/classes/prepare/certificates_spec.rb).

Most of the verification is done in hosts tests.

#### spec/hosts

Tests the module in the context of a particular node.  The module is loaded via
spec/fixtures/manifests/site.pp, and parameterized via heira according to the
:layout helper, or possibly a :node specific hieradata file if the test
generated one via run_with_custom_pe_conf().

Ordering of resources can be established with the have_a_resource() matcher from
spec/matchers/dependency_matchers.rb.

#### spec/unit

The pe_node_groups type and provider and functions are tested under spec/unit.

### Running Individual Specs

To run a specific spec file:

    $ bundle exec rake spec_standalone SPEC=spec/hosts/master_spec.rb

To run a specific example or context group, include the line number:

    $ bundle exec rake spec_standalone SPEC=spec/hosts/master_spec.rb:40

The specs require puppet to compile a catalog.  For the host specs in
particular, this can take several seconds, and when coupled with the
rspec-puppet-facts on_supported_os() helper, this can slow down spec runs,
making development irritating.  There is a helper in
spec/shared/rspec_puppet_facts.rb on_filtered_os() which can be used to
restrict specs to just a subset of os (:redhat, for instance).

The os platform is used as an rspec metadata tag as well.  And
you can run the specs against a particular platform as follows:

    $ bundle exec rake spec_standalone SPEC_OPTS="--tag os:redhat-7-x86_64"

This can be combined to select a specific SPEC file, but cannot be combined
with a :# line number setting; the line number setting will take precedence.

## Testing

Please see the testing information in the top level [README](../../README.md) on how to use Frankenbuilder and RSpec on your changes.

## Maintenance

Maintainers: Josh Partlow <joshua.partlow@puppetlabs.com>

Tickets: https://tickets.puppetlabs.com/browse/PE. Make sure to set component to 'PE Modules'.
