# Coordinates a few install/upgrade specific changes that were formally handled
# by the installer script, or are new to pe_install.
#
# * Halts services before upgrading packages
# * Clears cached catalogs if upgrading
# * Removes old logrotate config if upgrading
# * Sets up puppet config for PE
# * Generates certificates
class pe_install::prepare(
) {
  contain '::pe_install::upgrade::stop_services'
  contain '::pe_install::upgrade::clear_cached_catalogs'
  contain '::pe_install::upgrade::remove_logrotate_config_for_tk_services'
  contain '::pe_install::prepare::puppet_config'
  contain '::pe_install::prepare::certificates'

  $ca_reqs = $pe_install::is_ca ? {
    true  => [
      Class['puppet_enterprise::profile::certificate_authority'],
    ],
    false => []
  }
  $master_reqs = $pe_install::is_master ? {
    true  => [
      Class['puppet_enterprise::profile::master'],
    ],
    false => []
  }
  $orchestrator_reqs = $pe_install::is_orchestrator ? {
    true  => [
      Class['puppet_enterprise::profile::orchestrator'],
    ],
    false => []
  }
  $puppetdb_reqs = $pe_install::is_puppetdb ? {
    true  => [
      Class['puppet_enterprise::profile::puppetdb'],
    ],
    false => []
  }
  $database_reqs = $pe_install::is_database ? {
    true  => [
      Class['puppet_enterprise::profile::database'],
    ],
    false => []
  }
  $console_reqs = $pe_install::is_console ? {
    true  => [
      Class['puppet_enterprise::profile::console'],
    ],
    false => []
  }

  $profile_requirements =
    $ca_reqs +
    $master_reqs +
    $puppetdb_reqs +
    $database_reqs +
    $console_reqs

  Class['pe_install::prepare::certificates']
  -> $profile_requirements
}
